#include <QtGui>
#include "MainForm.h"
#include "MainTextEdit.h"
#include "NumberLine.h"
#include "TextEdit.h"
#include "tablewidget.h"
#include "ConnectionForm.h"
#include "DatabaseTree.h"

/*=======================================================
// MainTextEdit - 
========================================================*/
MainTextEdit::MainTextEdit( QWidget *parent )
    : QFrame( parent )
{
    setFrameStyle( QFrame::StyledPanel | QFrame::Sunken );
    setLineWidth( 2 );
	resize(800, 600);
    
	// Setup the main view
    this->textEdit = new TextEdit( this );
    this->textEdit->setFontFamily( "Courier" );
	this->textEdit->setFontPointSize(10);
    this->textEdit->setLineWrapMode( QTextEdit::NoWrap );
    this->textEdit->setFrameStyle( QFrame::NoFrame );
    this->textEdit->installEventFilter( this );

//    connect( this->textEdit->document(), SIGNAL(contentsChange(int,int,int)), this, SLOT(textChanged(int,int,int)) );

    // Setup line number
    this->numbers = new NumberLine( this );
    this->numbers->setTextEdit( this->textEdit );
    
	//Setup main Layout

    this->box = new QHBoxLayout( this );
    this->box->setSpacing( 0 );
    this->box->setMargin( 0 );
    this->box->addWidget( this->numbers );
    this->box->addWidget( this->textEdit );
}

/*=======================================================
// MainTextEdit - Ҹ
========================================================*/
MainTextEdit::~MainTextEdit()
{
}

/*=======================================================
// NumbereredTextView -  
========================================================*/
void MainTextEdit::setCurrentLine( int lineno )
{
    m_currentLine = lineno;
    numbers->setCurrentLine( lineno );
    textChanged( 0, 0, 1 );
	this->repaint();
}

/*=======================================================
// NumbereredTextView -  Ŀ  ȣ 
========================================================*/
int MainTextEdit::currentCursorline()
{
	QTextCursor textcursor = this->textEdit->textCursor();
	cursorLine = textcursor.blockNumber() + 1;
	return cursorLine;
}

/*=======================================================
// NumbereredTextView - Text ȯ
========================================================*/
void MainTextEdit::textChanged( int pos, int removed, int added )
{
    Q_UNUSED( pos );
	
    if ( removed == 0 && added == 0 )
		return;
	
    QTextBlock block = highlight.block();
    QTextBlockFormat fmt = block.blockFormat();
    QColor bg = textEdit->palette().base().color();
    fmt.setBackground( bg );
    highlight.setBlockFormat( fmt );
	
    int lineCount = 1;
    for ( QTextBlock block = textEdit->document()->begin();block.isValid(); block = block.next(), ++lineCount )
	{
		if ( m_currentLine == lineCount )
		{
			fmt = block.blockFormat();
			QColor bg = textEdit->palette().highlight().color().light( 150 );
			fmt.setBackground( bg );
			
			highlight = QTextCursor( block );
			highlight.movePosition( QTextCursor::EndOfBlock, QTextCursor::KeepAnchor );
			highlight.setBlockFormat( fmt );
		
			break;
		}
    }
}

/*=======================================================
// MainTextEdit - 극ũ Ʈ   ̺ Ʈ
========================================================*/
void MainTextEdit::setBreakpoint()
{
	// kang
	numbers->setBreakpoint(currentCursorline());
	ConnectionForm* connectionForm = ConnectionForm::getInstance();	
	QSqlDatabase* db = connectionForm->GetDb();	
	QString dbName = db->databaseName();

	MainForm* mainForm = ConnectionForm::getInstance()->GetMainForm();
	QString procedure = mainForm->GetFolderView()->currentItem()->text(0);
	QString names = dbName + "." + procedure;
	
	((tablewidget*)(mainForm->Get_breakpointinfotable()))->clear();
	((tablewidget*)(mainForm->Get_breakpointinfotable()))->insertRow(numbers->list.count());
	qSort(numbers->list.begin(), numbers->list.end());
	
	QString buffer;
	for(int i = 0; i< numbers->list.count(); i++)
	{	
		buffer = buffer.setNum(numbers->list[i]);
		((tablewidget*)(mainForm->Get_breakpointinfotable()))->setItem(i,0,new QTableWidgetItem(names));
		((tablewidget*)(mainForm->Get_breakpointinfotable()))->setItem(i,1,new QTableWidgetItem(buffer));
	}
	
}

/*=======================================================
// MainTextEdit -  극ũ Ʈ   ̺ Ʈ
========================================================*/
void MainTextEdit::Allbreakpointclear()
{
	// kang
	MainForm* mainForm = ConnectionForm::getInstance()->GetMainForm();
	numbers->AllBreakpointClear();
	((tablewidget*)(mainForm->Get_breakpointinfotable()))->clear();
	((tablewidget*)(mainForm->Get_breakpointinfotable()))->setRowCount(1);
	((tablewidget*)(mainForm->Get_breakpointinfotable()))->setColumnCount(2);	
}

/*=======================================================
// MainTextEdit - 극ũ Ʈ   ̺ Ʈ
========================================================*/
void MainTextEdit::breakpointclear()
{
	// kang
	numbers->BreakpointClear(currentCursorline());

	ConnectionForm* connectionForm = ConnectionForm::getInstance();	
	QSqlDatabase* db = connectionForm->GetDb();	
	QString dbName = db->databaseName();
	
	MainForm* mainForm = ConnectionForm::getInstance()->GetMainForm();
	QString procedure = mainForm->GetFolderView()->currentItem()->text(0);
	QString names = dbName + "." + procedure;

	QString buffer;
	((tablewidget*)(mainForm->Get_breakpointinfotable()))->clear();
	((tablewidget*)(mainForm->Get_breakpointinfotable()))->removeRow(numbers->list.count());
	qSort(numbers->list.begin(), numbers->list.end());
	for(int i = 0; i< numbers->list.count(); i++)
	{		
		buffer = buffer.setNum(numbers->list[i]);
		((tablewidget*)(mainForm->Get_breakpointinfotable()))->setItem(i,0,new QTableWidgetItem(names));
		((tablewidget*)(mainForm->Get_breakpointinfotable()))->setItem(i,1,new QTableWidgetItem(buffer));
	}
}

/*=======================================================
// MainTextEdit - 극ũ Ʈ    
========================================================*/
void MainTextEdit::slot_setBreakpoint()
{
	bool state = 0;
	int i=0;
	while( i < numbers->list.count() && state==0)
	{
		if(numbers->list[i] == currentCursorline())
		{
			state = 1;
		}
		i++;
	}
	
	if(state)
	{
		breakpointclear();
				
		qSort(numbers->list.begin(), numbers->list.end());
		QString buffer;
		for(int i = 0; i< numbers->list.count() ; i++)
		{	
			buffer = buffer.setNum(numbers->list[i]);
		}
	}
	else
	{
		setBreakpoint();
				
		qSort(numbers->list.begin(), numbers->list.end());
		QString buffer;
		for(int i = 0; i< numbers->list.count() ; i++)
		{	
			buffer = buffer.setNum(numbers->list[i]);
		}	
	}
}

/*=======================================================
// MainTextEdit -  극ũ Ʈ  
========================================================*/
void MainTextEdit::slot_Allbreakpointclear()
{
	Allbreakpointclear();
}
